<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('modules_data', function (Blueprint $table) {
            // Add extra fields 1-50
            for ($i = 1; $i <= 50; $i++) {
                $table->text("extra_field_{$i}")->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('modules_data', function (Blueprint $table) {
            // Drop extra fields 1-50
            for ($i = 1; $i <= 50; $i++) {
                $table->dropColumn("extra_field_{$i}");
            }
        });
    }
};
